/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs.converter;

import java.util.Optional;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class SmarterSlabConverter
implements SlabConverter {
    private Block slabBlock;

    public SmarterSlabConverter(Block slabBlock) {
        this.slabBlock = slabBlock;
    }

    @Override
    public BlockState getSingleSlab(BlockState state, SlabType slabType) {
        BlockState newState = this.slabBlock.m_49966_();
        for (Property property : state.m_61147_()) {
            if (property.m_61708_().equals("half")) {
                newState = this.getHalfBlockState(newState, property, slabType);
                continue;
            }
            newState = this.copyProperty(state, newState, property);
        }
        return newState;
    }

    @Override
    public boolean isDoubleSlab(BlockState state) {
        for (Property property : state.m_61147_()) {
            StringRepresentable value;
            if (!property.m_61708_().equals("half") || !(value = (StringRepresentable)state.m_61143_(property)).m_7912_().equals("full")) continue;
            return true;
        }
        return false;
    }

    private <T extends Comparable<T>> BlockState copyProperty(BlockState sourceState, BlockState targetState, Property<T> property) {
        return (BlockState)targetState.m_61124_(property, sourceState.m_61143_(property));
    }

    private <T extends Comparable<T>> BlockState getHalfBlockState(BlockState state, Property<T> property, SlabType slabType) {
        Optional parsedValue = Optional.empty();
        if (slabType == SlabType.BOTTOM) {
            parsedValue = property.m_6215_("bottom");
        } else if (slabType == SlabType.TOP) {
            parsedValue = property.m_6215_("top");
        }
        return parsedValue.map(t -> (BlockState)state.m_61124_(property, t)).orElse(state);
    }
}

